# TrustCaptcha for JTL — GDPR-compliant, privacy-first CAPTCHA

Protect websites and apps against bots and spam with a privacy-first, EU-hosted CAPTCHA solution.


## What is TrustCaptcha?

TrustCaptcha combines proof-of-work, an AI bot-score and custom security rules to stop automated bot abuse — without image marking or puzzles

Key perks:
- **Privacy-friendly & GDPR-compliant** – data processed exclusively in Europe
- **No visual challenges** – users never label images or solve quizzes
- **Fully themable widget** – matches any brand and design and improves your user flow
- **Conversion-safe** – near-zero user drop-off compared to legacy CAPTCHAs

Read the full [TrustCaptcha product overview](https://www.trustcomponent.com/en/products/captcha) for technical details and the security concept.


## Get started

1. **Create an account:** [sign up / sign in](https://id.trustcomponent.com/signup).
2. **Choose a CAPTCHA:** pick an existing one or create a new one.
3. **Install the Plugin:** install the TrustCaptcha plugin in your JTL instance.
4. **Configure TrustCaptcha:** Configure TrustCaptcha for your various JTL flows.

Need a walkthrough? See the [JTL integration guide](https://www.trustcomponent.com/en/products/captcha/integrations/jtl-shop-captcha-plugin).


## Basic JTL integration

Install the TrustCaptcha JTL plugin via the Plugin store or using composer.

**For detailed implementation instructions, [read the JTL integration guide](https://www.trustcomponent.com/en/products/captcha/integrations/jtl-shop-captcha-plugin).**


## Other pre-built integrations

TrustCaptcha ships ready-made integrations for popular stacks:
- Platforms like WordPress, Joomla, CraftCMS, Magento 2, Keycloak or JTL
- Frontends like JavaScript, Angular, React or Vue.js
- Backends like Node.js, PHP, Python, Java, Ruby, Rust, Go or DotNet
- Mobile Applications like iOS, Android, React Native or Flutter

[Discover all our pre-built Integrations](https://www.trustcomponent.com/en/products/captcha/integrations) on our website.


## Get support

Questions? We will be happy to help!
- Email: [mail@trustcomponent.com](mailto:mail@trustcomponent.com)
- Contact form: [reach the support team](https://www.trustcomponent.com/en/contact-us)
