<?php

namespace Trustcaptcha;

use Trustcaptcha\Settings\Settings;

class Initializer {

	public function setup(): void
    {
		$settings = new Settings();
		$settings->setup();

		add_action( 'init', [ $this, 'init' ] );
		add_action( 'wp_head', [ Trustcaptcha::class, 'load_head' ] );

		if ( ! function_exists( 'is_plugin_active' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		$this->load_enabled_plugins();
	}

	private function load_enabled_plugins(): void
    {
		$plugin_settings = get_option( 'trustcaptcha_plugins' );
		$plugins = [
			[ 'group' => 'wordpress',     'action' => 'login',         'plugins' => [], 'class' => Plugins\Wordpress\Login::class,],
			[ 'group' => 'wordpress',     'action' => 'register',      'plugins' => [], 'class' => Plugins\Wordpress\Register::class,],
			[ 'group' => 'wordpress',     'action' => 'comment',       'plugins' => [], 'class' => Plugins\Wordpress\Comment::class,],
			[ 'group' => 'wordpress',     'action' => 'lost_password', 'plugins' => [], 'class' => Plugins\Wordpress\LostPassword::class,],
			[ 'group' => 'wpforms',       'action' => 'form',          'plugins' => [ 'wpforms/wpforms.php', 'wpforms-lite/wpforms.php', 'wpforms-pro/wpforms.php' ], 'class' => Plugins\WPForms\WPForms::class,],
			[ 'group' => 'mailchimp',     'action' => 'form',          'plugins' => [ 'mailchimp-for-wp/mailchimp-for-wp.php' ], 'class' => Plugins\Mailchimp\MailchimpForms::class,],
			[ 'group' => 'woocommerce',   'action' => 'login',         'plugins' => [ 'woocommerce/woocommerce.php' ], 'class' => Plugins\Woocommerce\Login::class,],
			[ 'group' => 'woocommerce',   'action' => 'register',      'plugins' => [ 'woocommerce/woocommerce.php' ], 'class' => Plugins\Woocommerce\Register::class,],
			[ 'group' => 'woocommerce',   'action' => 'checkout',      'plugins' => [ 'woocommerce/woocommerce.php' ], 'class' => Plugins\Woocommerce\Checkout::class,],
			[ 'group' => 'woocommerce',   'action' => 'lost_password', 'plugins' => [ 'woocommerce/woocommerce.php' ], 'class' => Plugins\Woocommerce\LostPassword::class,],
			[ 'group' => 'forminator',    'action' => 'form',          'plugins' => [ 'forminator/forminator.php' ], 'class' => Plugins\Forminator\ForminatorForms::class,],
			[ 'group' => 'bbpress',       'action' => 'reply',         'plugins' => [ 'bbpress/bbpress.php' ], 'class' => Plugins\BBPress\Reply::class,],
			[ 'group' => 'bbpress',       'action' => 'new_topic',     'plugins' => [ 'bbpress/bbpress.php' ], 'class' => Plugins\BBPress\NewTopic::class,],
			[ 'group' => 'contactforms7', 'action' => 'form',          'plugins' => [ 'contact-form-7/wp-contact-form-7.php' ], 'class' => Plugins\ContactForm7\ContactForm7::class,],
			[ 'group' => 'ninja-forms',   'action' => 'form',          'plugins' => [ 'ninja-forms/ninja-forms.php' ], 'class' => Plugins\NinjaForms\NinjaForms::class,],
			[ 'group' => 'fluent-forms',  'action' => 'form',          'plugins' => [ 'fluentform/fluentform.php' ], 'class' => Plugins\FluentForms\FluentForms::class,],
			[ 'group' => 'elementor',     'action' => 'form',          'plugins' => [ 'elementor-pro/elementor-pro.php' ], 'class' => Plugins\Elementor\ElementorForms::class,],
			[ 'group' => 'gravityforms',  'action' => 'form',          'plugins' => [ 'gravityforms/gravityforms.php' ], 'class' => Plugins\GravityForms\GravityForms::class,],
		];

		foreach ( $plugins as $data ) {
			$files = $data['plugins'];
			$action = $data['action'];
			$group = $data['group'];
			$class = $data['class'];
			$plugin_setting = $plugin_settings[$group] ?? [];
			$plugin_enabled = in_array( $action, $plugin_setting, true );

            $wc_setting = $plugin_settings['woocommerce'] ?? [];
            $wc_login_enabled_in_settings = in_array( 'login', $wc_setting, true );
            $wc_plugin_active = $this->is_plugin_active( [ 'woocommerce/woocommerce.php' ] );
            if ( 'wordpress' === $group && 'login' === $action && $wc_login_enabled_in_settings && $wc_plugin_active ) {
                continue;
            }

			if ( $this->is_plugin_active( $files ) && $plugin_enabled ) {
				if ( isset( $class ) ) {
					new $class();
				}
			}
		}
	}

	public function is_plugin_active( $plugins ): bool
    {
		if ( count( $plugins ) === 0 ) {
			return true;
		}

		foreach ( $plugins as $plugin ) {
			if ( is_plugin_active( $plugin ) ) {
				return true;
			}

			if ( get_template() === $plugin ) {
				return true;
			}
		}
		return false;
	}

	public function init(): void
    {
        load_plugin_textdomain( 'trustcaptcha-for-forms', false, constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/languages' );
	}
}
