<?php

namespace Trustcaptcha\Plugins\BBPress;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

class NewTopic extends Plugin {

    public function init(): void
    {
		add_action( 'bbp_theme_after_topic_form_content', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'bbp_new_topic_pre_extras', [ $this, 'validate_captcha' ], 10, 3 );
    }

    public function validate_captcha(): bool
    {
		$validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            bbp_add_error( 'trustcaptcha_error', __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ) );

            return false;
        }

        return true;
    }
}
