<?php

namespace Trustcaptcha\Plugins\ContactForm7;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

use WPCF7_Submission;

class ContactForm7 extends Plugin {

    public function init(): void
    {
		add_filter( 'wpcf7_form_elements', [ $this, 'render_captcha' ], 20, 1 );
		add_filter( 'wpcf7_spam', [ $this, 'validate_captcha' ], 9, 1 );
        add_action( 'wp_print_footer_scripts', [ $this, 'load_scripts' ], 9 );
        add_filter( 'wpcf7_display_message', function( $message, $status ) {
            if ( 'spam' === $status && $custom = get_transient( 'trustcaptcha_error' ) ) {
                delete_transient( 'trustcaptcha_error' );
                return $custom;
            }
            return $message;
        }, 10, 2 );
    }

    public function render_captcha( string $elements )
    {
		return preg_replace(
        '/(<input.*?type="submit")/',
		Trustcaptcha::get_ob_html() . '$1',
		$elements
		);
	}

    public function validate_captcha( bool $spam ): bool
    {
		if ( $spam ) {
			return true;
		}

		$submission = WPCF7_Submission::get_instance();
		$validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $spam = true;
            set_transient( 'trustcaptcha_error', __( 'Captcha invalid - ' . $validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 30 );
            $submission->add_spam_log( array(
                'agent'  => 'trustcaptcha',
                'reason' => __( 'Captcha invalid - ' . $validationResponse->errorMessage, 'trustcaptcha-for-forms' ),
            ) );
        }

		return $spam;
	}

    public function load_scripts()
    {
		wp_enqueue_script(
            'trustcaptcha-contactforms7',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/contactForm7.js',
            [],
            PLUGIN_VERSION,
            true
        );
    }
}
