<?php

namespace Trustcaptcha\Plugins\FluentForms;

use Trustcaptcha\Plugins\Plugin;

class FluentForms extends Plugin {

    public function init(): void
    {
		add_action('fluentform/loaded', function () {
			new TrustcaptchaElement();
		});
        add_action( 'wp_print_footer_scripts', [ $this, 'load_scripts' ], 9 );
    }

    public function load_scripts()
    {
        wp_enqueue_script(
            'trustcaptcha-fluentforms',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/fluentForms.js',
            [],
            PLUGIN_VERSION,
            true
        );
    }
}
