<?php

namespace Trustcaptcha\Plugins\FluentForms;

use FluentForm\App\Services\FormBuilder\BaseFieldManager;
use Trustcaptcha\Trustcaptcha;

class TrustcaptchaElement extends BaseFieldManager {

	public function __construct()
    {
		parent::__construct(
        'tc-captcha-response',
        'Trustcaptcha',
        [ 'captcha' ],
        'advanced'
		);

		add_filter( 'fluentform/response_render_' . $this->key, array( $this, 'renderResponse' ), 10, 3 );
		add_filter( 'fluentform/validate_input_item_' . $this->key, array( $this, 'validate_captcha' ), 10, 5 );
	}

	public function getComponent()
    {
		return [
			'index'          => 16,
			'element'        => $this->key,
			'attributes'     => [
				'name' => $this->key,
			],
			'settings'       => [
				'label'            => '',
				'validation_rules' => [],
			],
			'editor_options' => [
				'title'      => $this->title,
				'icon_class' => 'ff-edit-recaptcha',
				'template'   => 'inputHidden',
			],
		];
	}

	public function render( $data, $form )
    {
		$element_name = $data['element'];
		$settings = $data['settings'];

		$label = '';
		if ( ! empty( $settings['label'] ) ) {
            $label = "<div class='ff-el-input--label'><label>" . $settings['label'] . '</label></div>';
        }

		$container_class = '';
        if ( ! empty( $settings['label_placement'] ) ) {
            $container_class = 'ff-el-form-' . $settings['label_placement'];
        }

		$captcha = Trustcaptcha::build_html();

		$el = "<div class='ff-el-input--content'><div data-fluent_id='" . $form->id . "'>{$captcha}</div></div>";
        $html = "<div class='ff-el-group " . esc_attr( $container_class ) . "' >" . fluentform_sanitize_html( $label ) . "{$el}</div>";

		$this->printContent( 'fluentform/rendering_field_html_' . $element_name, $html, $data, $form );
	}

    public function renderResponse( $response, $field, $form_id )
    {
        return $response;
    }

	public function validate_captcha( $error_message, $field, $form_data, $fields, $form )
    {
        $response = '';
        if ( isset($_POST['data']) ) {
            parse_str($_POST['data'], $parsedData);
            $response = isset($parsedData['tc-verification-token']) ? sanitize_text_field($parsedData['tc-verification-token']) : '';
        }

        if ( empty( $response ) ) {
			return [ __( 'Please fill out the captcha', 'trustcaptcha-for-forms' ) ];
		}

        $validationResponse = Trustcaptcha::validateCaptcha( $response );

        if ( ! $validationResponse->captchaPassed ) {
            $error_message = [ __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ) ];
        }

		return $error_message;
	}
}
