<?php

namespace Trustcaptcha\Plugins\Forminator;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

class ForminatorForms extends Plugin {

    public function init(): void
    {
		add_filter( 'forminator_render_button_markup', [ $this, 'render_captcha' ], 10, 2 );
        add_filter( 'forminator_cform_form_is_submittable', [ $this, 'validate_captcha' ], 10, 3 );
        add_action( 'wp_print_footer_scripts', [ $this, 'load_scripts' ], 9 );
    }

    public function render_captcha( string $html, string $button ): string
    {
        return str_replace(
            '<button ',
            Trustcaptcha::get_ob_html() .
                '<button ',
            (string) $html
        );
    }

    public function validate_captcha( $can_show, int $id, array $form_settings ): array
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            return [
                'can_submit' => false,
                'error'      => __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ),
            ];
        }

        return $can_show;
    }

    public function load_scripts()
    {
        wp_enqueue_script(
            'trustcaptcha-forminator',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/forminator.js',
            [ 'jquery', 'trustcaptcha-form' ],
            PLUGIN_VERSION,
            true
        );
    }
}
