<?php

namespace Trustcaptcha\Plugins\GravityForms;

use Trustcaptcha\Trustcaptcha;
use GFFormsModel;
use Trustcaptcha\Plugins\Plugin;

class GravityForms extends Plugin {

	protected $message;

    public function init(): void
    {
		add_action( 'gform_loaded', [ $this, 'register_field' ], 10, 0 );
		add_filter( 'gform_validation', [ $this, 'validate_captcha' ], 10, 2 );
		add_filter( 'gform_form_validation_errors', [ $this, 'form_validation_errors' ], 10, 2 );
	}

	public function register_field()
    {
		new TrustcaptchaField();
	}

	public function validate_captcha( $validation_result, string $context )
    {
		if ( ! $this->can_verify() ) {
			return $validation_result;
		}

		$validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

		if (! $validationResponse->captchaPassed) {
			$this->message = __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' );
			$validation_result['is_valid']                  = false;
			$validation_result['form']['validationSummary'] = '1';
        }

		return $validation_result;
	}

	public function form_validation_errors( $errors, array $form )
    {
		if ( empty( $this->message ) ) {
			return $errors;
		}

		$error['field_selector'] = '';
		$error['field_label']    = 'Trustcaptcha';
		$error['message']        = $this->message;

		$errors[] = $error;

		return $errors;
	}

	private function can_verify(): bool
    {
		if ( ! isset( $_POST['gform_submit'] ) ) {
			return false;
		}

		$form_id = (int) $_POST['gform_submit'];
		$target_page_name = "gform_target_page_number_$form_id";

		if ( isset( $_POST[ $target_page_name ] ) ) {
			$source_page_name = "gform_source_page_number_$form_id";
			$target_page = (int) $_POST[ $target_page_name ];
			$source_page = isset( $_POST[ $source_page_name ] ) ? (int) $_POST[ $source_page_name ] : 0;
			$form_meta = (array) GFFormsModel::get_form_meta( $form_id );
			$last_page = 0 !== (int) $_POST[ $target_page_name ] &&
			$target_page !== $source_page &&
			isset(
				$form_meta['pagination']['pages'][ $target_page - 1 ],
				$form_meta['pagination']['pages'][ $source_page - 1 ]
			);

			if ( $last_page ) {
				return false;
			}
		}

		if ( $this->is_captcha_on_form( $form_id ) ) {
			return true;
		}

		return false;
	}

	private function is_captcha_on_form( int $form_id ): bool
    {
		$form = GFFormsModel::get_form_meta( $form_id );

		if ( ! $form ) {
			return false;
		}

		$captcha_types = [ 'captcha', 'trustcaptcha' ];

		foreach ( $form['fields'] as $field )
        {
			if ( in_array( $field->type, $captcha_types, true ) ) {
				return true;
			}
		}

		return false;
	}
}
