<?php

namespace Trustcaptcha\Plugins\GravityForms;

use GF_Field;
use GF_Fields;
use Exception;
use GFCommon;
use Trustcaptcha\Trustcaptcha;

class TrustcaptchaField extends GF_Field {

    public $type = 'trustcaptcha';
	public $label = 'Trustcaptcha';

	public function __construct( array $data = [] )
    {
		parent::__construct( $data );
		$this->setup();
	}

	private function setup(): void
    {
		try {
			GF_Fields::register( $this );
		} catch ( Exception $e ) {
			return;
		}

		add_filter( 'gform_field_groups_form_editor', [ $this, 'add_to_field_groups' ] );
		add_action( 'admin_print_footer_scripts-toplevel_page_gf_edit_forms', [ $this, 'load_scripts' ] );
	}

	public function add_to_field_groups( array $field_groups ): array
    {
		$field_groups['advanced_fields']['fields'][] = [
			'data-type' => 'trustcaptcha',
			'value'     => 'Trustcaptcha',
		];

		return $field_groups;
	}

	public function get_form_editor_field_title()
    {
		return esc_attr( 'Trustcaptcha' );
	}

	public function get_form_editor_field_description()
    {
		return ( esc_attr__( 'Adds a Trustcaptcha field to your form to help protect your website from spam and bot abuse.', 'trustcaptcha-for-forms' ));
	}

	public function get_field_sidebar_messages()
    {
		if ( ( ! empty( Trustcaptcha::get_site_key() ) && ! empty( Trustcaptcha::get_secret_key() ) ) ) {
			return '';
		}

		return sprintf( __( 'To use Trustcaptcha you must configure the site and secret keys on the %1$sTrustcaptcha General Settings%2$s page.', 'trustcaptcha-for-forms' ), "<a href='/wp-admin/options-general.php?page=trustcaptcha' target='_blank'>", '</a>' );
	}

	public function get_form_editor_field_icon()
    {
		return TRUSTCAPTCHA_BASE_URL . '/assets/img/tc-icon-light.svg';
	}

	public function get_form_editor_field_settings()
    {
		return [
			'label_placement_setting',
			'description_setting',
			'css_class_setting',
		];
	}

	public function get_field_input( $form, $value = '', $entry = null )
    {
		$form_id         = (int) $form['id'];
		$is_entry_detail = $this->is_entry_detail();
		$is_form_editor  = $this->is_form_editor();
		$id              = (int) $this->id;
		$field_id        = $is_entry_detail || $is_form_editor || 0 === $form_id ? "input_$id" : 'input_' . $form_id . "_$id";
		$tabindex = GFCommon::$tab_index > 0 ? GFCommon::$tab_index++ : 0;
		$search = 'class="trustcaptcha"';

		return str_replace(
			$search,
			$search . ' id="' . $field_id . '" data-tabindex="' . $tabindex . '"',
			Trustcaptcha::build_html()
		);
	}

    public function load_scripts()
    {
        wp_enqueue_script( 'trustcaptcha-form', constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/form.js', [], PLUGIN_VERSION, true );
        wp_enqueue_script( 'trustcaptcha', Trustcaptcha::get_script(), [], PLUGIN_VERSION, true );
	}

}
