<?php

namespace Trustcaptcha\Plugins\Mailchimp;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

use MC4WP_Form;
use MC4WP_Form_Element;

class MailchimpForms extends Plugin {

    public function init(): void
    {
		add_filter( 'mc4wp_form_content', [ $this, 'render_captcha' ], 20, 3 );
        add_filter( 'mc4wp_form_errors', [ $this, 'validate_captcha' ], 10, 2 );
        add_filter( 'mc4wp_form_messages', [ $this, 'add_error_messages' ], 10, 2 );
    }

    public function render_captcha( string $content, MC4WP_Form $form, MC4WP_Form_Element $element ): string
    {
        return preg_replace(
            '/(<input.*?type="submit")/',
		Trustcaptcha::get_ob_html() . '$1',
		    $content
		);
    }

    public function add_error_messages( $messages, MC4WP_Form $form )
    {
        $messages = (array) $messages;
        $messages['invalid'] = [
            'type' => 'error',
            'text' => __( 'Invalid Captcha', 'trustcaptcha-for-forms' ),
        ];
        return $messages;
    }

    public function validate_captcha( $errors, MC4WP_Form $form )
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $errors     = (array) $errors;
            $errors[]   = 'invalid';
        }

        return $errors;
    }
}
