<?php

namespace Trustcaptcha\Plugins\NinjaForms;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

class NinjaForms extends Plugin {

    public function init(): void
    {
        add_filter( 'ninja_forms_register_fields', [ $this, 'register_field' ] );
		add_filter( 'ninja_forms_field_template_file_paths', [ $this, 'register_template' ] );
		add_filter( 'ninja_forms_localize_field_trustcaptcha', [ $this, 'render_field' ] );
		add_action( 'wp_enqueue_scripts', [ $this, 'load_scripts' ] );
    }

	public function register_field( $fields ): array
    {
		$fields = (array) $fields;
		$fields['trustcaptcha'] = new TrustcaptchaField();

		return $fields;
	}

	public function register_template( $paths ): array
    {
		$paths = (array) $paths;
		$paths[] = __DIR__ . '/templates/';

		return $paths;
	}

    public function render_field( $field ): array
    {
		$field = (array) $field;
		$id = $field['id'] ?? 0;
		$trustcaptcha = str_replace(
			'<div',
			'<div id="nf-tc-' . $id . '"',
			Trustcaptcha::get_ob_html()
		);

		$field['settings']['trustcaptcha'] = $trustcaptcha;
		return $field;
	}

    public function load_scripts()
    {
		wp_enqueue_script(
            'trustcaptcha-ninjaforms',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/ninjaforms.js',
            [ 'nf-front-end' ],
            PLUGIN_VERSION,
            true
        );
    }
}
