<?php
namespace Trustcaptcha\Plugins\NinjaForms;

use Trustcaptcha\Trustcaptcha;
use NF_Fields_Recaptcha;

class TrustcaptchaField extends NF_Fields_Recaptcha {

    protected $_name = 'trustcaptcha';
    protected $_type = 'trustcaptcha';
    protected $_templates = 'trustcaptcha';
    protected $_nicename;

    public function __construct()
    {
        parent::__construct();
        $this->_nicename = __( 'Trustcaptcha', 'trustcaptcha-for-forms' );
    }

	public function validate( $field, $data )
    {
		$value = $field['value'] ?? '';

        if ( empty( $value ) ) {
            return __( 'Please complete the captcha', 'trustcaptcha-for-forms' );
        }

        $validationResponse = Trustcaptcha::validateCaptcha( $value );
        if ( ! $validationResponse->captchaPassed ) {
            return __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' );
        }
	}
}
