<?php

namespace Trustcaptcha\Plugins\WPForms;

use Trustcaptcha\Plugins\Plugin;
use Trustcaptcha\Trustcaptcha;

class WPForms extends Plugin {

    public function init(): void
    {
		add_action( 'wpforms_display_submit_before', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'wpforms_process', [ $this, 'validate_captcha' ], 10, 3 );
        add_action( 'wp_enqueue_scripts', [ $this, 'load_scripts' ] );
    }

    public function validate_captcha( array $fields, array $entry, array $form_data ): void
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            wpforms()->get( 'process' )->errors[ $form_data['id'] ]['footer'] = __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' );
        }
    }

    public function load_scripts()
    {
        wp_enqueue_script(
            'trustcaptcha-wpforms',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/wpForms.js',
            [],
            PLUGIN_VERSION,
            true
        );
    }
}
