<?php

namespace Trustcaptcha\Plugins\Woocommerce;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;

class Checkout extends Plugin {

    public function init(): void
    {
		add_action( 'woocommerce_review_order_before_submit', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'woocommerce_checkout_process', [ $this, 'validate_captcha' ] );
        add_action( 'wp_enqueue_scripts', [ $this, 'load_scripts' ] );
    }

    public function validate_captcha(): void
    {
		$validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            wc_add_notice( __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 'error' );
        }
    }

    public function load_scripts()
    {
		wp_enqueue_script(
            'trustcaptcha-woocommerce',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/woocommerce.js',
            [ 'jquery' ],
            PLUGIN_VERSION,
            true
        );
    }
}
