<?php

namespace Trustcaptcha\Plugins\Woocommerce;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class Login extends Plugin {

    public function init(): void
    {
        add_action( 'woocommerce_login_form', [ Trustcaptcha::class, 'get_html' ] );
        add_filter( 'woocommerce_process_login_errors', [ $this, 'validate_captcha' ] );
    }

    public function validate_captcha( $validation_error )
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $validation_error = new WP_Error( 'invalid_captcha', __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }

        return $validation_error;
    }
}
