<?php

namespace Trustcaptcha\Plugins\Woocommerce;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class LostPassword extends Plugin {

    public function init(): void
    {
		add_action( 'woocommerce_lostpassword_form', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'lostpassword_post', [ $this, 'validate_captcha' ] );
    }

    public function validate_captcha( $error )
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $error = new WP_Error( 'invalid_captcha', __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }

        return $error;
    }
}
