<?php

namespace Trustcaptcha\Plugins\Wordpress;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class Comment extends Plugin {

    public function init(): void
    {
        add_filter( 'comment_form_submit_field', [ $this, 'render' ], 10, 2 );
        add_filter( 'pre_comment_approved', [ $this, 'validate_captcha' ], 20, 2 );
        add_action( 'wp_print_footer_scripts', [ $this, 'load_scripts' ], 9 );
    }

    public function render( $submit_field, $args ): string
    {
        return Trustcaptcha::get_ob_html() . $submit_field;
    }

    public function validate_captcha( $approved, array $commentdata ) {
        static $already_called = false;
        if ( $already_called ) {
            return $approved;
        }
        $already_called = true;

        if ( is_admin() ) {
            return $approved;
        }

        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $approved = new WP_Error( 'invalid_captcha', __( 'Captcha invalid - ' . $validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }

        return $approved;
    }

    public function load_scripts()
    {
        wp_enqueue_script(
            'trustcaptcha-wpforms',
            constant( 'TRUSTCAPTCHA_BASE_URL' ) . '/assets/js/wordpressComment.js',
            [],
            PLUGIN_VERSION,
            true
        );
    }
}
