<?php

namespace Trustcaptcha\Plugins\Wordpress;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class Login extends Plugin {

    public function init(): void
    {
		add_action( 'login_form', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'login_head', [ Trustcaptcha::class, 'load_head' ] );
        add_filter( 'wp_authenticate_user', [ $this, 'validate_captcha' ], 10, 2 );
    }

    public function validate_captcha( $user, string $password ): mixed
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            return new WP_Error( 'invalid_captcha', __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }

        return $user;
    }
}
