<?php

namespace Trustcaptcha\Plugins\Wordpress;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class LostPassword extends Plugin {

    public function init(): void
    {
        add_action( 'lostpassword_form', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'login_head', [ Trustcaptcha::class, 'load_head' ] );
        add_action( 'lostpassword_post', [ $this, 'validate_captcha' ], 10, 1 );
    }

    public function validate_captcha( &$error ): void {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $error->add( 'invalid_captcha', __( 'Captcha invalid - ' . $validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }
    }
}
