<?php

namespace Trustcaptcha\Plugins\Wordpress;

use Trustcaptcha\Trustcaptcha;
use Trustcaptcha\Plugins\Plugin;
use WP_Error;

class Register extends Plugin {

    public function init(): void
    {
		add_action( 'register_form', [ Trustcaptcha::class, 'get_html' ] );
        add_action( 'login_head', [ Trustcaptcha::class, 'load_head' ] );
        add_filter( 'registration_errors', [ $this, 'validate_captcha' ], 10, 3 );
    }

    public function validate_captcha( $errors, string $sanitized_user_login, string $user_email ): mixed
    {
        $validationResponse = Trustcaptcha::validateCaptchaWithPostVerificationToken();

        if ( ! $validationResponse->captchaPassed ) {
            $errors = new WP_Error( 'invalid_captcha', __( 'Captcha invalid - '.$validationResponse->errorMessage, 'trustcaptcha-for-forms' ), 400 );
        }

        return $errors;
    }
}
