<?php

namespace Trustcaptcha\Settings;

class General {

    public function setup()
    {
        $group = 'trustcaptcha_options';
        register_setting( 'trustcaptcha', $group );
        add_settings_section( $group, __( 'General settings', 'trustcaptcha-for-forms' ), [ $this, 'init_settings_section' ], 'trustcaptcha' );

        // Basisfelder
        add_settings_field( 'field_site_key', __( 'Site key (required)', 'trustcaptcha-for-forms' ), [ $this, 'render_text_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_site_key',
            'class'     => 'tc-row',
            'group'     => $group,
        ]);
        add_settings_field( 'field_secret_key', __( 'Secret key (required)', 'trustcaptcha-for-forms' ), [ $this, 'render_text_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_secret_key',
            'class'     => 'tc-row',
            'group'     => $group,
            'type'      => 'password',
        ]);
        add_settings_field( 'field_license_key', __( 'License key', 'trustcaptcha-for-forms' ), [ $this, 'render_text_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_license_key',
            'class'     => 'tc-row',
            'group'     => $group,
            'type'      => 'password',
            'description' => __( 'A license key is required for features like hide branding, custom privacy url, invisible CAPTCHA widget or custom design.', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field( 'field_threshold', __( 'Threshold (required)', 'trustcaptcha-for-forms' ), [ $this, 'render_number_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_threshold',
            'class'     => 'tc-row',
            'group'     => $group,
            'type'      => 'number',
            'min'       => 0,
            'max'       => 1,
            'step'      => 0.05,
            'description' => __( 'The bot score is always between 0 (probably a human) and 1 (probably a bot or spam). The lower the threshold, the more secure the bot protection.', 'trustcaptcha-for-forms' ),
        ]);

        // Neue Felder
        add_settings_field( 'field_width', __( 'Width', 'trustcaptcha-for-forms' ), [ $this, 'render_select_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_width',
            'class'     => 'tc-row',
            'group'     => $group,
            'options'   => [
                'fixed' => __( 'Fixed', 'trustcaptcha-for-forms' ),
                'full'  => __( 'Full', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field( 'field_language', __( 'Language', 'trustcaptcha-for-forms' ), [ $this, 'render_select_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_language',
            'class'     => 'tc-row',
            'group'     => $group,
            'options'   => [
                'auto' => __( 'Auto Detection', 'trustcaptcha-for-forms' ),
                'ar'   => __( 'Arabic', 'trustcaptcha-for-forms' ),
                'be'   => __( 'Belarusian', 'trustcaptcha-for-forms' ),
                'bg'   => __( 'Bulgarian', 'trustcaptcha-for-forms' ),
                'bs'   => __( 'Bosnian', 'trustcaptcha-for-forms' ),
                'ca'   => __( 'Catalan', 'trustcaptcha-for-forms' ),
                'cs'   => __( 'Czech', 'trustcaptcha-for-forms' ),
                'da'   => __( 'Danish', 'trustcaptcha-for-forms' ),
                'de'   => __( 'German', 'trustcaptcha-for-forms' ),
                'el'   => __( 'Greek', 'trustcaptcha-for-forms' ),
                'en'   => __( 'English', 'trustcaptcha-for-forms' ),
                'es'   => __( 'Spanish', 'trustcaptcha-for-forms' ),
                'et'   => __( 'Estonian', 'trustcaptcha-for-forms' ),
                'fi'   => __( 'Finnish', 'trustcaptcha-for-forms' ),
                'fr'   => __( 'French', 'trustcaptcha-for-forms' ),
                'hi'   => __( 'Hindi', 'trustcaptcha-for-forms' ),
                'hr'   => __( 'Croatian', 'trustcaptcha-for-forms' ),
                'hu'   => __( 'Hungarian', 'trustcaptcha-for-forms' ),
                'it'   => __( 'Italian', 'trustcaptcha-for-forms' ),
                'ko'   => __( 'Korean', 'trustcaptcha-for-forms' ),
                'lb'   => __( 'Luxembourgish', 'trustcaptcha-for-forms' ),
                'lt'   => __( 'Lithuanian', 'trustcaptcha-for-forms' ),
                'lv'   => __( 'Latvian', 'trustcaptcha-for-forms' ),
                'mk'   => __( 'Macedonian', 'trustcaptcha-for-forms' ),
                'nl'   => __( 'Dutch', 'trustcaptcha-for-forms' ),
                'no'   => __( 'Norwegian', 'trustcaptcha-for-forms' ),
                'pl'   => __( 'Polish', 'trustcaptcha-for-forms' ),
                'pt'   => __( 'Portuguese', 'trustcaptcha-for-forms' ),
                'ro'   => __( 'Romanian', 'trustcaptcha-for-forms' ),
                'ru'   => __( 'Russian', 'trustcaptcha-for-forms' ),
                'sk'   => __( 'Slovak', 'trustcaptcha-for-forms' ),
                'sl'   => __( 'Slovenian', 'trustcaptcha-for-forms' ),
                'sq'   => __( 'Albanian', 'trustcaptcha-for-forms' ),
                'sr'   => __( 'Serbian', 'trustcaptcha-for-forms' ),
                'sv'   => __( 'Swedish', 'trustcaptcha-for-forms' ),
                'tr'   => __( 'Turkish', 'trustcaptcha-for-forms' ),
                'uk'   => __( 'Ukrainian', 'trustcaptcha-for-forms' ),
                'zh'   => __( 'Chinese', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field( 'field_theme', __( 'Theme', 'trustcaptcha-for-forms' ), [ $this, 'render_select_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_theme',
            'class'     => 'tc-row',
            'group'     => $group,
            'options'   => [
                'light' => __( 'Light', 'trustcaptcha-for-forms' ),
                'dark'  => __( 'Dark', 'trustcaptcha-for-forms' ),
                'media' => __( 'Media', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field( 'field_autostart', __( 'Autostart', 'trustcaptcha-for-forms' ), [ $this, 'render_checkbox_field' ], 'trustcaptcha', $group, [
            'label_for'     => 'field_autostart',
            'class'         => 'tc-row',
            'group'         => $group,
            'checkbox_text' => __( 'Autostart', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field( 'field_privacy_url', __( 'Privacy URL', 'trustcaptcha-for-forms' ), [ $this, 'render_text_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_privacy_url',
            'class'     => 'tc-row',
            'group'     => $group,
            'placeholder'=> __( 'https://example.com/privacy', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field( 'field_hide_branding', __( 'Hide Branding', 'trustcaptcha-for-forms' ), [ $this, 'render_checkbox_field' ], 'trustcaptcha', $group, [
            'label_for'     => 'field_hide_branding',
            'class'         => 'tc-row',
            'group'         => $group,
            'checkbox_text' => __( 'Hide Branding', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field( 'field_invisible', __( 'Invisible', 'trustcaptcha-for-forms' ), [ $this, 'render_checkbox_field' ], 'trustcaptcha', $group, [
            'label_for'     => 'field_invisible',
            'class'         => 'tc-row',
            'group'         => $group,
            'checkbox_text' => __( 'Invisible', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field( 'field_invisible_hint', __( 'Invisible Hint', 'trustcaptcha-for-forms' ), [ $this, 'render_select_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_invisible_hint',
            'class'     => 'tc-row',
            'group'     => $group,
            'options'   => [
                'inline'      => __( 'Inline', 'trustcaptcha-for-forms' ),
                'right-border'=> __( 'Right Border', 'trustcaptcha-for-forms' ),
                'right-bottom'=> __( 'Right Bottom', 'trustcaptcha-for-forms' ),
                'hidden'      => __( 'Hidden', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field( 'field_mode', __( 'Mode', 'trustcaptcha-for-forms' ), [ $this, 'render_select_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_mode',
            'class'     => 'tc-row',
            'group'     => $group,
            'options'   => [
                'standard' => __( 'Standard', 'trustcaptcha-for-forms' ),
                'minimal'  => __( 'Minimal Data Mode', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field( 'field_custom_translations', __( 'Custom Translations', 'trustcaptcha-for-forms' ), [ $this, 'render_textarea_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_custom_translations',
            'class'     => 'tc-row',
            'group'     => $group,
        ]);
        add_settings_field( 'field_custom_design', __( 'Custom Design', 'trustcaptcha-for-forms' ), [ $this, 'render_textarea_field' ], 'trustcaptcha', $group, [
            'label_for' => 'field_custom_design',
            'class'     => 'tc-row',
            'group'     => $group,
        ]);
    }

    public function init_settings_section()
    {
        ?><p><?php esc_html_e( 'Configure your TrustCaptcha settings.', 'trustcaptcha-for-forms' ); ?> <?php esc_html_e( 'If you do not have a CAPTCHA yet, ', 'trustcaptcha-for-forms' ); ?> <a href="https://dashboard.trustcomponent.com/en/solution-creation" target="_blank"><?php esc_html_e( 'you can create a CAPTCHA here for free.', 'trustcaptcha-for-forms' ); ?></a></p><?php
    }

    public function get_tab_content()
    {
		?>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'trustcaptcha' );
            do_settings_sections( 'trustcaptcha' );
            submit_button( __( 'Save Settings', 'trustcaptcha-for-forms' ) );
            ?>
        </form>
		<?php
    }

    public function render_text_field( $args )
    {
        SettingForms::render_text_field( $args );
    }

    public function render_number_field( $args )
    {
        SettingForms::render_number_field( $args );
    }

    public function render_select_field( $args )
    {
        SettingForms::render_select_field( $args );
    }

    public function render_checkbox_field( $args )
    {
        SettingForms::render_checkbox_field( $args );
    }

    public function render_textarea_field( $args )
    {
        SettingForms::render_textarea_field( $args );
    }
}
