<?php

namespace Trustcaptcha\Settings;

class Network {

    public function setup() {
        $group = 'trustcaptcha_network_options';
        register_setting('trustcaptcha_network_options', $group);

        add_settings_section(
            $group,
            __('Network Settings', 'trustcaptcha-for-forms'),
            [$this, 'init_settings_section'],
            'trustcaptcha_network_options'
        );

        add_settings_field(
            'field_enable_proxy',
            __('Enable Proxy', 'trustcaptcha-for-forms'),
            [$this, 'render_checkbox_field'],
            'trustcaptcha_network_options',
            $group,
            [
                'label_for'     => 'field_enable_proxy',
                'class'         => 'tc-row',
                'group'         => $group,
                'checkbox_text' => __('Enable Proxy', 'trustcaptcha-for-forms'),
            ]
        );

        add_settings_field(
            'field_proxy_host',
            __('Proxy Host', 'trustcaptcha-for-forms'),
            [$this, 'render_text_field'],
            'trustcaptcha_network_options',
            $group,
            [
                'label_for'   => 'field_proxy_host',
                'class'       => 'tc-row',
                'group'       => $group,
                'placeholder' => 'http://proxy.example.com:8080',
                'description' => __('Include protocol and port, e.g. http://proxy.example.com:8080', 'trustcaptcha-for-forms'),
            ]
        );

        add_settings_field(
            'field_proxy_username',
            __('Proxy Username', 'trustcaptcha-for-forms'),
            [$this, 'render_text_field'],
            'trustcaptcha_network_options',
            $group,
            [
                'label_for' => 'field_proxy_username',
                'class'     => 'tc-row',
                'group'     => $group,
                'placeholder' => 'admin',
                'description' => __('Leave blank if no username is required', 'trustcaptcha-for-forms'),

            ]
        );

        add_settings_field(
            'field_proxy_password',
            __('Proxy Password', 'trustcaptcha-for-forms'),
            [$this, 'render_text_field'],
            'trustcaptcha_network_options',
            $group,
            [
                'label_for' => 'field_proxy_password',
                'class'     => 'tc-row',
                'group'     => $group,
                'type'      => 'password',
                'description' => __('Leave blank if no password is required', 'trustcaptcha-for-forms'),
            ]
        );
    }

    public function init_settings_section() {
        ?>
        <p>
            <?php esc_html_e('Configure your proxy settings if you use a network proxy.', 'trustcaptcha-for-forms'); ?>
        </p>
        <?php
    }

    public function get_tab_content() {
        ?>
        <form action="options.php" method="post">
            <?php
            settings_fields('trustcaptcha_network_options');
            do_settings_sections('trustcaptcha_network_options');
            submit_button(__('Save Settings', 'trustcaptcha-for-forms'));
            ?>
        </form>
        <?php
    }

    public function render_text_field( $args )
    {
        SettingForms::render_text_field( $args );
    }

    public function render_checkbox_field( $args )
    {
        SettingForms::render_checkbox_field( $args );
    }
}
