<?php

namespace Trustcaptcha\Settings;

class Plugins {

    public function setup()
    {
        $setting_plugins = 'trustcaptcha_plugins';
        register_setting( $setting_plugins, $setting_plugins );
        add_settings_section( $setting_plugins, __( 'Manage plugins', 'trustcaptcha-for-forms' ), [ $this, 'init_plugins_section' ], $setting_plugins );
        add_settings_field('WordPress', $this->get_plugin_logo( 'wordpress' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'wordpress',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => true,
            'options'   => [
                'login'         => __( 'Login Form', 'trustcaptcha-for-forms' ),
                'register'      => __( 'Register Form', 'trustcaptcha-for-forms' ),
                'lost_password' => __( 'Lost Password Form', 'trustcaptcha-for-forms' ),
                'comment'       => __( 'Comment Form', 'trustcaptcha-for-forms' ),
            ],
            'hint'      => __( 'Note: Before you activate the login form - make sure that Trustcaptcha is configured correctly and the threshold is at best not below 0.5 so that you are not locked out of your own WordPress website.', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field('woocommerce', $this->get_plugin_logo( 'woocommerce' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'woocommerce',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'woocommerce/woocommerce.php' ),
            'options'   => [
                'login'         => __( 'Login Form', 'trustcaptcha-for-forms' ),
                'register'      => __( 'Register Form', 'trustcaptcha-for-forms' ),
                'lost_password' => __( 'Lost Password Form', 'trustcaptcha-for-forms' ),
                'checkout'      => __( 'Checkout', 'trustcaptcha-for-forms' ),
            ],
            'hint'      => __( 'Note: Before you activate the login form - make sure that Trustcaptcha is configured correctly and the threshold is at best not below 0.5 so that you are not locked out of your own WordPress website.', 'trustcaptcha-for-forms' ),
        ]);
        add_settings_field('elementor', $this->get_plugin_logo( 'elementor' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'elementor',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'elementor-pro/elementor-pro.php' ),
            'options'   => [
                'form' => __( 'Elementor Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('wpforms', $this->get_plugin_logo( 'wpforms' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'wpforms',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'wpforms/wpforms.php' ) || is_plugin_active( 'wpforms-lite/wpforms.php' ) || is_plugin_active( 'wpforms-pro/wpforms.php' ),
            'options'   => [
                'form' => __( 'WPForms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('mailchimp', $this->get_plugin_logo( 'mailchimp' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'mailchimp',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'mailchimp-for-wp/mailchimp-for-wp.php' ),
            'options'   => [
                'form' => __( 'Mailchimp Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('forminator', $this->get_plugin_logo( 'forminator' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'forminator',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'forminator/forminator.php' ),
            'options'   => [
                'form' => __( 'Forminator Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('bbpress', $this->get_plugin_logo( 'bbpress' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'bbpress',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'bbpress/bbpress.php' ),
            'options'   => [
                'reply'     => __( 'Reply Form', 'trustcaptcha-for-forms' ),
                'new_topic' => __( 'New Topic Form', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('contactforms7', $this->get_plugin_logo( 'contactforms7' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'contactforms7',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'contact-form-7/wp-contact-form-7.php' ),
            'options'   => [
                'form' => __( 'Contact Forms 7', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('ninja-forms', $this->get_plugin_logo( 'ninja-forms' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'ninja-forms',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'ninja-forms/ninja-forms.php' ),
            'options'   => [
                'form' => __( 'Ninja Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('gravityforms', $this->get_plugin_logo( 'gravityforms' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'gravityforms',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'gravityforms/gravityforms.php' ),
            'options'   => [
                'form' => __( 'Gravity Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
        add_settings_field('fluent-forms', $this->get_plugin_logo( 'fluent-forms' ), [ $this, 'render_plugin_field' ], $setting_plugins, $setting_plugins, [
            'label_for' => 'fluent-forms',
            'class'     => 'tc-plugin-item',
            'group'     => $setting_plugins,
            'available' => is_plugin_active( 'fluentform/fluentform.php' ),
            'options'   => [
                'form' => __( 'Fluent Forms', 'trustcaptcha-for-forms' ),
            ],
        ]);
    }

    public function init_plugins_section()
    {
		?>
        <p class="tc-plugins-text"><?php esc_html_e( 'Activate Trustcaptcha for WordPress third-party plugins.', 'trustcaptcha-for-forms' ); ?> <?php esc_html_e( 'If you a missing a plugin,', 'trustcaptcha-for-forms' ); ?> <a href="https://www.trustcomponent.com/en/contact-us" target="_blank"><?php esc_html_e( 'please contact our support team.', 'trustcaptcha-for-forms' ); ?></a></p>
		<?php
    }

    public function get_tab_content()
    {
		?>
        <form action="options.php" method="post" class="tc-plugins">
            <?php
            settings_fields( 'trustcaptcha_plugins' );
            do_settings_sections( 'trustcaptcha_plugins' );
            submit_button( __( 'Save Changes', 'trustcaptcha-for-forms' ) );
            ?>
        </form>
		<?php
    }

    public function render_plugin_field( $args )
    {
        $option_group = $args['group'];
        $plugin_available = isset( $args['available'] ) ? $args['available'] : false;
        $options = get_option( $option_group );
        $field_name = esc_attr( $args['label_for'] );
        $current_value = isset( $options[ $field_name ] ) ? $options[ $field_name ] : [];

        $select_options = '';
        foreach ( $args['options'] as $attr => $value ) {
            if ( null === $value ) {
                continue;
            }
            $name = sprintf('%s[%s][]', $option_group, $field_name);
            $id = sprintf('%s[%s]', $field_name, $attr);
            $checked = in_array( $attr, $current_value, true ) ? 'checked ' : '';
            $disabled = $plugin_available ? '' : 'disabled=""';
            $select_options .= sprintf(
                '<div><input name="%s" id="%s" type="checkbox" value="%s" %s/><label for="%s">%s</label></div>',
                esc_attr( $name ),
                esc_attr( $id ),
                esc_attr( $attr ),
                esc_attr( $checked . $disabled ),
                esc_attr( $id ),
                esc_html( $value )
            );
        }

        $allowed_html = [
            'div'   => [],
            'input' => [
                'value'    => [],
                'name'     => [],
                'type'     => [],
                'id'       => [],
                'checked'  => [],
                'disabled' => [],
            ],
            'label' => [
                'for' => [],
            ],
            'p'     => [
                'class' => [],
            ],
        ];

        printf(
            '<div class="tc-input-plugin">%s</div>',
            wp_kses( rtrim( $select_options ), $allowed_html )
        );

        if ( isset( $args['hint'] ) && $args['hint'] ) {
            printf(
                '<p class="description" style="margin-top: 12px; color: darkred">%s</p>',
                esc_html( $args['hint'] )
            );
        }
    }

    private function get_plugin_logo( string $plugin )
    {
        return sprintf( '<img src="%s" height="40px"/>', constant( 'TRUSTCAPTCHA_BASE_URL' ) . "/assets/img/plugins/$plugin.png" );
    }
}
