<?php

namespace Trustcaptcha\Settings;

class SettingForms {

    public static function render_text_field( $args )
    {
        $group   = esc_attr( $args['group'] );
        $options = get_option( $group );
        $field   = esc_attr( $args['label_for'] );
        $type    = esc_attr( $args['type'] ?? 'text' );
        $placeholder = esc_attr( $args['placeholder'] ?? '' );
        $value   = esc_attr( $options[ $field ] ?? '' );

        printf('<input id="%s" name="%s[%s]" type="%s" placeholder="%s" value="%s">', $field, $group, $field, $type, $placeholder, $value);

        if ( ! empty( $args['description'] ) ) {
            printf('<p class="description">%s</p>', esc_html( $args['description'] ));
        }
    }

    public static function render_number_field( $args )
    {
        $group   = esc_attr( $args['group'] );
        $options = get_option( $group );
        $field   = esc_attr( $args['label_for'] );
        $type    = esc_attr( $args['type'] ?? 'number' );
        $min     = esc_attr( $args['min'] );
        $max     = esc_attr( $args['max'] );
        $step    = esc_attr( $args['step'] );
        if ( 'field_threshold' === $field && !isset( $options[ $field ] ) ) {
            $value = '0.5';
        } else {
            $value = esc_attr( $options[ $field ] ?? '' );
        }

        printf('<input id="%s" name="%s[%s]" type="%s" value="%s" min="%s" max="%s" step="%s">', $field, $group, $field, $type, $value, $min, $max, $step);

        if ( ! empty( $args['description'] ) ) {
            printf('<p class="description">%s</p>', esc_html( $args['description'] ));
        }
    }

    public static function render_select_field( $args )
    {
        $group   = esc_attr( $args['group'] );
        $options = get_option( $group );
        $field   = esc_attr( $args['label_for'] );
        $value   = $options[ $field ] ?? '';

        $optionsHtml = '';
        foreach ( $args['options'] as $attr => $text ) {
            if ( null === $text ) {
                continue;
            }
            $optionsHtml .= sprintf('<option value="%s" %s>%s</option>', $attr, selected( $attr, $value, false ), $text);
        }
        $allowed = ['option' => ['value' => [], 'selected' => []]];

        printf('<select id="%s" name="%s[%s]">%s</select>', $field, $group, $field, wp_kses( $optionsHtml, $allowed ));

        if ( ! empty( $args['description'] ) ) {
            printf('<p class="description">%s</p>', esc_html( $args['description'] ));
        }
    }

    public static function render_checkbox_field( $args )
    {
        $group   = esc_attr( $args['group'] );
        $options = get_option( $group );
        $field   = esc_attr( $args['label_for'] );
        $value   = $options[ $field ] ?? '';
        $checked = checked( 1, $value, false );

        $html = sprintf('<input id="%s" name="%s[%s]" type="checkbox" value="1" %s>', $field, $group, $field, $checked);

        if ( ! empty( $args['checkbox_text'] ) ) {
            $html .= sprintf('<label for="%s">%s</label>', $field, esc_html( $args['checkbox_text'] ));
        }

        echo $html;
    }

    public static function render_textarea_field( $args )
    {
        $group   = esc_attr( $args['group'] );
        $options = get_option( $group );
        $field   = esc_attr( $args['label_for'] );
        $placeholder = esc_attr( $args['placeholder'] ?? '' );
        $value   = esc_textarea( isset( $options[ $field ] ) ? $options[ $field ] : '' );

        printf('<textarea id="%s" name="%s[%s]" placeholder="%s">%s</textarea>', $field, $group, $field, $placeholder, $value);

        if ( ! empty( $args['description'] ) ) {
            printf('<p class="description">%s</p>', esc_html( $args['description'] ));
        }
    }
}
