// @ts-expect-error Marionette is globally available
const TrustcaptchaFieldController = Marionette.Object.extend({
  initialize() {
    this.listenTo(
      // @ts-expect-error nfRadio is globally available
      nfRadio.channel('submit'),
      'validate:field',
      this.updateField
    );

    this.listenTo(
      // @ts-expect-error nfRadio is globally available
      nfRadio.channel('fields'),
      'change:modelValue',
      this.updateField
    );

    this.listenTo(
      // @ts-expect-error nfRadio is globally available
      nfRadio.channel('nfMP'),
      'change:part',
      this.changePart,
      this
    );
  },
  updateField: function (model: any) {
    if ('trustcaptcha' !== model.get('type')) {
      return;
    }

    const id = model.get('id');
    const value = model.get('value');

    if (value) {
      // @ts-expect-error nfRadio is globally available
      nfRadio.channel('fields').request('remove:error', id, 'required-error');
      return;
    }

    const widgetInForm = document.querySelector(`#nf-tc-${id}`);
    if (!widgetInForm) {
      return;
    }

    const verificationTokenInput = document.querySelector<HTMLInputElement>('input[name="tc-verification-token"]');
    if (!verificationTokenInput) {
      return;
    }

    model.set('value', verificationTokenInput.value);
  },
});

jQuery(document).ready(() => {
  new TrustcaptchaFieldController();
});
