<?php
/**
 * TrustCaptcha WordPress Plugin
 *
 * @package trustcaptcha
 *
 * Plugin Name:           TrustCaptcha for WordPress
 * Plugin URI:            https://www.trustcomponent.com/en/products/captcha/integrations/wordpress-captcha-plugin
 * Description:           Privacy-friendly CAPTCHA solution with bot score. Protect your website from bot attacks and spam with our invisible and GDPR-compliant reCAPTCHA alternative. Benefit from our multi-layered security concept with proof-of-work and intelligent bot score for reliable bot detection.
 * Version:               2.0.0
 * Author:                TrustComponent
 * Author URI:            https://www.trustcomponent.com
 * Text Domain:           trustcaptcha
 * Domain Path:           /languages
 *
 * Requires at least: 4.0
 * Tested up to: 6.8
 * Requires PHP: 7.0
 *
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

use Trustcaptcha\Initializer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'TRUSTCAPTCHA_BASE_URL', untrailingslashit( plugin_dir_url( __FILE__ ) ) );

const TRUSTCAPTCHA_BASE_FILE = __FILE__;
const PLUGIN_VERSION = '2.0.0';

require 'vendor/autoload.php';

function trustcaptcha(): Initializer
{
	static $trustcaptcha;
	if ( ! $trustcaptcha ) {
		$trustcaptcha = new Initializer();
	}
	return $trustcaptcha;
}

trustcaptcha()->setup();
